//
//  WXKMailWindowController_Communication.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/08/27.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
//
//  Some part of this source code is derived from AirHPhone.m, 
//  written by raktajino in AH-K3001V Bookmark Utility and distributed
//  under BSD license.
//  Communicational protocol to AH-K3001V was referred to ``AirH" 
//  AH-K3001 station'' (http://www.softclub.jp/zoro/ce/usb.html), written
//  by Zoroyoshi and distributed under BSD license.
//  See the following about copyrights.
//
//
//  Created by raktajino on Thu Jun 17 2004.
//  Copyright (c) 2004 raktajino. All rights reserved.
//
//		Copyright (c) 04 Zoroyoshi, Japan
//		All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.



#import "WXKMailWindowController.h"
#import "WXKProgressWindowController.h"
#import "WXKPhone.h"


@implementation WXKMailWindowController (Communication)


- (BOOL)receiveWithPassword:(NSString *)password error:(NSError **)error
{
	// Begin to communicate with Kyopon.
	WXKPhone *phone = [[WXKPhone alloc] init];
	
	WXKProgressWindowController	*progressWindowController = [[WXKProgressWindowController alloc] initWithParentWindow:[self window]];
	
	// Receive data from Kyopon.
	NSArray *lightMailDataArray, *eMailDataArray = nil;
	BOOL succeeds = ([phone receiveAllItemsOfDataType:WXKPhoneLightMailDataType
										intoDataArray:&lightMailDataArray
										 withPassword:password
											 progress:progressWindowController
												error:error]
					 && [phone receiveAllItemsOfDataType:WXKPhoneEmailDataType
										   intoDataArray:&eMailDataArray
											withPassword:password
												progress:progressWindowController
												   error:error]
												   );
												
	
	[phone release];
	[progressWindowController release];
	
	if (succeeds) {
	
//		[foldersTableView setNeedsDisplay:NO];
//		[itemsTableView setNeedsDisplay:NO];
		
		// If successfully received data, then parse the data.
		
		NSManagedObjectContext *context = [self managedObjectContext];
		
		// remove all existemt mails
		
		NSEnumerator *enumerator = [[itemsController allObjects] objectEnumerator];
		id item;
		while (item = [enumerator nextObject]) {
			[context deleteObject:item];
		}
		[context processPendingChanges];
		
		NSArray *allMailBoxes = [foldersController allObjects];
//		NSManagedObject *indexManager = [itemsController valueForKey:@"indexManager"];
		NSDateFormatter *lightMailDateFormatter = [self lightMailDateFormatter];
		
		SInt32 order = 0;
		NSData *data;
		
		// parse lightmails' data
		
		enumerator = [lightMailDataArray objectEnumerator];
		
		while (data = [enumerator nextObject]) {
		
			NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
			
			NSData *dataFields[7] = {nil, nil, nil, nil, nil, nil};
			if ([WXKPhone parseDataFields:dataFields 
										  fieldNumber:7 
											 withData:data]) {
				
				NSString *stringFields[6] = {nil, nil, nil, nil, nil, nil};
				int i;
				for (i = 0; i < 6; i++) {
					if (dataFields[i] != nil) {
						stringFields[i] = [[[NSString alloc] initWithData:dataFields[i] encoding:NSShiftJISStringEncoding] autorelease];
					}
				}
				
				// generate an object and set its attributes.
				NSManagedObject *lightMail = [NSEntityDescription insertNewObjectForEntityForName:@"LightMail"
																		   inManagedObjectContext:context];
				
				NSPredicate *predicate = [NSPredicate predicateWithFormat:@"order == %d", [stringFields[0] intValue]];
				NSArray *filteredMailBoxes = [allMailBoxes filteredArrayUsingPredicate:predicate];
				id mailBox = [filteredMailBoxes lastObject];
				
				NSNumber *indexNumber = (stringFields[1] ? [NSNumber numberWithInt:[stringFields[1] intValue]]: nil);
				NSNumber *statusNumber = (stringFields[2] ? [NSNumber numberWithInt:[stringFields[2] intValue]] : nil);
				NSNumber *securedNumber = (stringFields[3] ? [NSNumber numberWithBool:[stringFields[3] isEqualToString:@"ON"]] : nil);
				NSDate *date = (stringFields[4] ? [lightMailDateFormatter dateFromString:stringFields[4]] : nil);
				
				[lightMail setValue:mailBox forKey:@"folder"];
				[lightMail setValue:indexNumber forKey:@"index"];
				[lightMail setValue:statusNumber forKey:@"status"];
				[lightMail setValue:securedNumber forKey:@"secured"];
				
				[lightMail setValue:date forKey:@"date"];
				[lightMail setValue:stringFields[5] forKey:@"object"];
				[lightMail setValue:dataFields[6] forKey:@"message"];
				[lightMail setValue:[NSNumber numberWithLong:order++] forKey:@"order"];
			}
			
			[pool release];
		}
		
		// parse emails' data
		
		enumerator = [eMailDataArray objectEnumerator];
		
		while (data = [enumerator nextObject]) {
			
			NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
			
			NSData *dataFields[5] = {nil, nil, nil, nil, nil};
			
			if ([WXKPhone parseDataFields:dataFields
						  fieldNumber:5
							 withData:data]) {
				
				NSString *stringFields[4] = {nil, nil, nil, nil};
				int i;
				for (i = 0; i < 4; i++) {
					if (dataFields[i] != nil) {
						stringFields[i] = [[[NSString alloc] initWithData:dataFields[i] encoding:NSShiftJISStringEncoding] autorelease];
					}
				}
				
				// generate an object and set its attributes.
				
				NSManagedObject *eMail = [NSEntityDescription insertNewObjectForEntityForName:@"EMail"
																	   inManagedObjectContext:context];
				
				NSPredicate *predicate = [NSPredicate predicateWithFormat:@"order == %d", [stringFields[0] intValue]];
				NSArray *filteredMailBoxes = [allMailBoxes filteredArrayUsingPredicate:predicate];
				id mailBox = [filteredMailBoxes lastObject];
				
				NSNumber *indexNumber = (stringFields[1] ? [NSNumber numberWithInt:[stringFields[1] intValue]]: nil);
				NSNumber *statusNumber = (stringFields[2] ? [NSNumber numberWithInt:[stringFields[2] intValue]] : nil);
				NSNumber *securedNumber = (stringFields[3] ? [NSNumber numberWithBool:[stringFields[3] isEqualToString:@"ON"]] : nil);
				
				[eMail setValue:mailBox forKey:@"folder"];
				[eMail setValue:indexNumber forKey:@"index"];
				[eMail setValue:statusNumber forKey:@"status"];
				[eMail setValue:securedNumber forKey:@"secured"];
				[eMail setValue:dataFields[4] forKey:@"message"];
				[eMail setValue:[NSNumber numberWithLong:order++] forKey:@"order"];
			}
			
//			NSString *filename = [NSString stringWithFormat:@"%03d.eMailData", i];
//			NSString *filepath = [NSHomeDirectory() stringByAppendingPathComponent:filename];
//			[[eMailDataArray objectAtIndex:i] writeToFile:filepath atomically:YES];
			
			[pool release];
		}
		
//		[foldersTableView setNeedsDisplay:YES];
//		[itemsTableView setNeedsDisplay:YES];
		
		return YES;
	} else {
		return NO;
	}
}

@end